<?php
define('DIR', realpath(__DIR__) . DIRECTORY_SEPARATOR);
$tokens_file = DIR . 'reset_tokens.json';
$config_path = DIR . 'config.json';

// Sprawdź token
function is_valid_token($token) {
    global $tokens_file;
    if (!file_exists($tokens_file)) return false;

    $tokens = json_decode(file_get_contents($tokens_file), true);

    return isset($tokens[$token]) && $tokens[$token]['expires'] > time();
}

// Aktualizuj hasło
function update_password($new_pass) {
    global $config_path;
    if (!file_exists($config_path)) return false;

    $config = json_decode(file_get_contents($config_path), true);
    $config['pass'] = password_hash($new_pass, PASSWORD_BCRYPT, ['cost' => 11]);

    return file_put_contents($config_path, json_encode($config, JSON_UNESCAPED_UNICODE));
}

// Usuń token
function remove_token($token) {
    global $tokens_file;
    if (!file_exists($tokens_file)) return;

    $tokens = json_decode(file_get_contents($tokens_file), true);
    unset($tokens[$token]);
    file_put_contents($tokens_file, json_encode($tokens, JSON_UNESCAPED_UNICODE));
}

// Obsługa POST
$token = $_GET['token'] ?? ($_POST['token'] ?? '');
$error = '';
$success = false;

if (!$token) {
    exit("❌ Brak tokena w adresie URL.");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_pass = $_POST['password'] ?? '';

    if (strlen($new_pass) < 6) {
        $error = "Hasło musi mieć co najmniej 6 znaków.";
    } elseif (!is_valid_token($token)) {
        $error = "Nieprawidłowy lub wygasły link.";
    } else {
        if (update_password($new_pass)) {
            remove_token($token);
            $success = true;
        } else {
            $error = "❌ Błąd zapisu pliku konfiguracyjnego.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <title>Resetowanie hasła - SES-App</title>
    <?php if ($success): ?>
    <meta http-equiv="refresh" content="3;url=index.php">
    <?php endif; ?>
    <style>
        body { font-family: sans-serif; padding: 40px; max-width: 500px; margin: auto; background: #f9f9f9; }
        input[type=password], button { width: 100%; padding: 10px; margin-top: 10px; font-size: 16px; }
        .success { color: green; margin-bottom: 20px; }
        .error { color: red; margin-bottom: 20px; }
        .form-box { background: white; padding: 20px; border-radius: 8px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
    </style>
</head>
<body>

<div class="form-box">
    <h2>Zresetuj swoje hasło</h2>

    <?php if ($error): ?>
        <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <?php if ($success): ?>
        <div class="success">
            ✅ Hasło zostało zaktualizowane. Za chwilę nastąpi przekierowanie do strony logowania...
        </div>
        <script>
            setTimeout(() => {
                window.location.href = 'index.php';
            }, 3000);
        </script>
    <?php elseif (!is_valid_token($token)): ?>
        <div class="error">Nieprawidłowy lub wygasły link.</div>
    <?php else: ?>
        <form method="post">
            <input type="hidden" name="token" value="<?= htmlspecialchars($token) ?>">
            <label for="password">Nowe hasło:</label>
            <input type="password" name="password" required placeholder="Wprowadź nowe hasło">
            <button type="submit">Ustaw nowe hasło</button>
        </form>
    <?php endif; ?>
</div>

</body>
</html>
