<?php
define('DIR', realpath(__DIR__) . DIRECTORY_SEPARATOR);
$config_path = DIR . 'config.json';
$tokens_path = DIR . 'reset_tokens.json';

if (!file_exists($config_path)) {
    exit('Brak pliku konfiguracyjnego.');
}

$config = json_decode(file_get_contents($config_path), true);

// Dekoduj e-mail
function decode_user($hex_base64) {
    return base64_decode(hex2bin($hex_base64));
}

// Generuj token
function generate_token($length = 32) {
    return bin2hex(random_bytes($length / 2));
}

// Zapisz token do pliku
function save_token($token, $email) {
    $tokens = file_exists(DIR . 'reset_tokens.json') ? json_decode(file_get_contents(DIR . 'reset_tokens.json'), true) : [];
    $tokens[$token] = [
        'email' => $email,
        'expires' => time() + 3600 // 1 godzina
    ];
    file_put_contents(DIR . 'reset_tokens.json', json_encode($tokens, JSON_UNESCAPED_UNICODE));
}

// Wyślij e-mail
function send_email($to, $token) {
    $url = "https://demo.sesapp.es/reset_password.php?token=$token";
    $subject = "Reset your password - SES-App";
    $message = "Hello,\n\nClick the link below to reset your password:\n$url\n\nThis link is valid for 1 hour.";
    $headers = "From: no-reply@sesapp.es\r\n";
    return mail($to, $subject, $message, $headers);
}

// Proces
$email = decode_user($config['user']);
$token = generate_token();

save_token($token, $email);
$success = send_email($email, $token);
?>

<!DOCTYPE html>
<html lang="pl">
<head>
    <meta charset="UTF-8">
    <title>Reset hasła - SES-App</title>
    <style>
        body { font-family: sans-serif; padding: 40px; background: #f4f4f4; }
        .container {
            max-width: 500px;
            margin: auto;
            background: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 0 15px rgba(0,0,0,0.1);
            text-align: center;
        }
        h2 { margin-bottom: 20px; }
        .message {
            font-size: 16px;
            color: <?= $success ? 'green' : 'red' ?>;
            margin-top: 20px;
        }
        .back {
            display: inline-block;
            margin-top: 30px;
            text-decoration: none;
            color: #0075d4;
            font-weight: bold;
        }
    </style>
</head>
<body>

<div class="container">
    <h2>Resetowanie hasła</h2>

    <div class="message">
        <?php if ($success): ?>
            ✅ Link do resetu hasła został wysłany na adres: <strong><?= htmlspecialchars($email) ?></strong><br>
            Sprawdź swoją skrzynkę mailową.
        <?php else: ?>
            ❌ Nie udało się wysłać wiadomości e-mail.<br>
            Spróbuj ponownie lub skontaktuj się z administratorem.
        <?php endif; ?>
    </div>

    <a class="back" href="index.php">← Powrót do logowania</a>
</div>

</body>
</html>
