function addTenant(data) {

	data = $.extend({
		edit: false,
		id: $(document).find('.tenantBlock').length,
		title: _lang.BTNS.ADD,
		type: 'VI',
		name: '',
		surname: '',
		secondsurname: '',
		docType: '',
		number: '',
		docNumber: '',
		birth: Date.now(),
		birthDay: new Date ().getDate ().toString ().padStart (2,'0'),
		birthMonth: (new Date ().getMonth () + 1).toString ().padStart (2,'0'),
		birthYear: new Date ().getFullYear (),
		nationality: 'ESP',
		genre: '',
		adress: [],
		zip: '',
		city: '0',
		locality: '',
		country: 'ESP',
		phone: [],
		email: '',
		relation: 'NULL'
	}, data);

	data.birth = new Date(data.birth * 1000);

	const birthDay = data.birth.getDate();
	const birthMonth = data.birth.getMonth() + 1;
	const birthYear = data.birth.getFullYear();

	$modal = $(`
		<div class="modal fade" tabindex="-1" data-bs-backdrop="static" data-bs-keyboard="false">
			<div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
				<div class="modal-content">
					<div class="modal-header">
						<h1 class="modal-title fs-5">${data.title}</h1>
						<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
					</div>
					<div class="modal-body">
						<form id="tenant">
							<div class="form-floating mb-3 d-none">
								<select class="form-select" placeholder="${_lang.TENANT.TYPE}" name="type" id="type">
									${$.map(_lang.TENANT.TYPES,(v,k)=>`<option value="${k}"${k==data.type?` selected`:''}>${v}</option>`).join('')}
								</select>
								<label for="type">${_lang.TENANT.TYPE}</label>
							</div>
							<div class="form-floating mb-3">
								<input type="text" class="form-control" id="name" name="name" maxlength="50" placeholder="${_lang.TENANT.NAME}" value="${data.name}" required />
								<label for="name">${_lang.TENANT.NAME}</label>
							</div>
							<div class="form-floating mb-3">
								<input type="text" class="form-control" id="surname" name="surname" maxlength="50" placeholder="${_lang.TENANT.SURNAME}" value="${data.surname}" required />
								<label for="surname">${_lang.TENANT.SURNAME}</label>
							</div>
							<div class="form-floating">
								<input type="text" class="form-control" id="secondsurname" name="secondsurname" maxlength="50" placeholder="${_lang.TENANT.SECONDSURNAME}" value="${data.secondsurname}" />
								<label for="secondsurname">${_lang.TENANT.SECONDSURNAME}</label>
							</div>
							<div class="text-muted mb-3" style="font-size: 0.75rem;">${_lang.TENANT.SECONDSURNAMEMANDATORY}</div>
							<div class="form-floating mb-3">
								<select class="form-select" placeholder="${_lang.TENANT.DOC}" name="docType" id="docType" onchange="onChangeDocType(event)">
									${$.map(_lang.TENANT.DOCTYPES,(v,k)=>`<option value="${k}"${k==data.docType?` selected`:''}>${v}</option>`).join('')}
								</select>
								<label for="docType">${_lang.TENANT.DOC}</label>
							</div>
							<div class="form-floating">
								<input type="text" class="form-control" id="number" name="number" maxlength="15" placeholder="${_lang.TENANT.DOCNUMBER}" value="${data.number}" required />
								<label for="number">${_lang.TENANT.DOCNUMBER}</label>
							</div>
							<div class="text-muted mb-3" style="font-size: 0.75rem;">${_lang.TENANT.DOCNUMBERMANDATORY}</div>
							<div class="form-floating">
								<input type="text" class="form-control" id="docNumber" name="docNumber" maxlength="9" placeholder="${_lang.TENANT.DOCSUPPORT}" value="${data.docNumber}" onblur="validateDocSupport (event);" />
								<label for="docNumber">${_lang.TENANT.DOCSUPPORT}</label>
							</div>
							<div class="text-muted" style="font-size: 0.75rem;">${_lang.TENANT.DOCSUPPORTMANDATORY}</div>
							<div class="text-danger d-none" id="wrongDNISupport" style="font-size: 0.75rem;">${_lang.TENANT.DOCSUPPORTWRONG.DNI}</div>
							<div class="text-danger d-none" id="wrongNIESupport" style="font-size: 0.75rem;">${_lang.TENANT.DOCSUPPORTWRONG.DNI}</div>
							<div class="mb-3"></div>
							<div class="mb-3">
							<input type="hidden" name="birth" id="birthHidden" />
							<label class="form-label">${_lang.TENANT.BIRTH}</label>
							<div class="d-flex gap-2">
								<select id="birthDay" name="birthDay" class="form-select" required></select>
								<select id="birthMonth" name="birthMonth" class="form-select" required></select>
								<select id="birthYear" name="birthYear" class="form-select" required></select>
							</div>
							</div>
							<div class="position-relative mb-3">
								<label for="nationality" class="form-label">${_lang.TENANT.NATIONALITY}:</label>
								<select class="form-select select2" placeholder="${_lang.TENANT.NATIONALITY}" id="nationality" name="nationality"></select>
							</div>
							<div class="form-floating mb-3">
								<select class="form-select" placeholder="${_lang.TENANT.GENDER}" name="genre" id="genre">
									${$.map(_lang.TENANT.GENDERTYPES,(v,k)=>`<option value="${k}"${k==data.genre?` selected`:''}>${v}</option>`).join('')}
								</select>
								<label for="genre">${_lang.TENANT.GENDER}</label>
							</div>
							<!-- DIRECCION -->
							<div class="form-floating mb-3">
								<input type="text" class="form-control" id="adress[0]" name="adress[0]" maxlength="100" placeholder="${_lang.TENANT.ADRESS}" value="${data.adress[0]??''}" required />
								<label for="adress[0]">${_lang.TENANT.ADRESS}</label>
							</div>
							<div class="form-floating mb-3">
								<input type="text" class="form-control" id="adress[1]" name="adress[1]" maxlength="100" placeholder="${_lang.TENANT.ADITIONALADRESS}" value="${data.adress[1]??''}" />
								<label for="adress[1]">${_lang.TENANT.ADITIONALADRESS}</label>
							</div>
							<div class="position-relative">
								<label for="city" class="form-label">${_lang.TENANT.CITY}:</label>
								<select class="form-select select2" placeholder="${_lang.TENANT.CITY}" id="city" name="city"></select>
							</div>
							<div class="text-muted mb-3" style="font-size: 0.75rem;">${_lang.TENANT.CITYMANDATORY}</div>
							<div class="form-floating">
								<input type="text" class="form-control" id="locality" name="locality" maxlength="100" placeholder="${_lang.TENANT.LOCALITY}" value="${data.locality}" />
								<label for="locality">${_lang.TENANT.LOCALITY}</label>
							</div>
							<div class="text-muted mb-3" style="font-size: 0.75rem;">${_lang.TENANT.CITYNOMANDATORY}</div>
							<div class="form-floating mb-3">
								<input type="text" class="form-control" id="zip" name="zip" maxlength="100" placeholder="${_lang.TENANT.ZIP}" value="${data.zip}" required />
								<label for="zip">${_lang.TENANT.ZIP}</label>
							</div>
							<div class="position-relative mb-3">
								<label for="country" class="form-label">${_lang.TENANT.COUNTRY}:</label>
								<select class="form-select select2" placeholder="${_lang.TENANT.COUNTRY}" id="country" name="country" required></select>
							</div>
							<!-- END DIRECCION -->
							<div class="form-floating mb-3">
								<input type="text" class="form-control" id="phone[0]" name="phone[0]" maxlength="20" placeholder="${_lang.TENANT.PHONE}" value="${data.phone[0]??''}" required />
								<label for="phone[0]">${_lang.TENANT.PHONE}</label>
							</div>

							<div class="form-floating mb-3">
								<input type="email" class="form-control" id="email" name="email" maxlength="250" placeholder="${_lang.TENANT.EMAIL}" value="${data.email}" />
								<label for="email">${_lang.TENANT.EMAIL}</label>
							</div>
							<div class="form-floating">
								<select class="form-select" placeholder="${_lang.TENANT.RELATION}" name="relation" id="relation">
									${$.map(_lang.TENANT.RELATIONTYPES,(v,k)=>`<option value="${k}"${k==data.relation?` selected`:''}>${v}</option>`).join('')}
								</select>
								<label for="relation">${_lang.TENANT.RELATION}</label>
							</div>
							<div class="text-muted" style="font-size: 0.75rem;">${_lang.TENANT.RELATIONMSG}</div>
						</form>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-dark submitTenant">${_lang.BTNS.SAVE}</button>
					</div>
				</div>
			</div>
		</div>
`).appendTo('body');

	$bsModal = new bootstrap.Modal($modal);
	$bsModal.toggle();

	$modal.on('shown.bs.modal', () => {

		// Dni
		for (let d = 1; d <= 31; d++) {
			$modal.find('#birthDay').append(`<option value="${d}"${data.birthDay==d?' selected':''}>${d.toString().padStart(2, '0')}</option>`);
		}

		// Miesiące
		for (let m = 1; m <= 12; m++) {
			$modal.find('#birthMonth').append(`<option value="${m}"${data.birthMonth==m?' selected':''}>${m.toString().padStart(2, '0')}</option>`);
		}

		// Lata 1900 – dzisiaj
		const currentYear = new Date().getFullYear();
		for (let y = currentYear; y >= 1900; y--) {
			$modal.find('#birthYear').append(`<option value="${y}"${data.birthYear==y?' selected':''}>${y}</option>`);
		}


		if(!data.edit){data.birth='';}
		$modal.find('#tenant #birth').datepicker('update', data.birth);
		// Selects
		$.getJSON(`${_u}lib/co-co.json`, d => {
			// Nationality
			$modal.find('#tenant select.select2#nationality').select2({
				language: _l,
				theme: 'bootstrap-5',
				dropdownParent: $modal,
				data: $.map(d,i=>({
					id: i.alpha3Code,
					text: i.nativeName,
					flag: i.flag,
					spelling: i.altSpellings,
					selected: data.nationality == i.alpha3Code
				})),
				sorter: param => param.sort((a,b)=>a.text.localeCompare(b.text)),
				templateResult: param => {
					if(!param.id){return param.text??false;}
					return $(`
						<div class="d-flex justify-content-start align-items-center">
							<div class="col-2 text-center"><img class="img-fluid" style="height:40px;width:auto;" alt="${param.text}" src="${param.flag}" /></div>
							<div class="col-10 ps-1">${param.text}</div>
						</div>
					`);
				},
				templateSelection: param => {
					if(!param.id){return param.text??false;}
					return $(`
						<div class="d-flex justify-content-start align-items-center">
							<div class="col-2 text-center"><img class="img-fluid" style="height:40px;width:auto;" alt="${param.text}" src="${param.flag}" /></div>
							<div class="col-10 ps-1">${param.text}</div>
						</div>
					`);
				},
				matcher: (search,param) => {
					if(!param.id){return false;}
					if(!search.term){return param;}

					const term = search.term.toLowerCase();
					const text = param.text?.toLowerCase()??'';
					const id = param.id?.toLowerCase()??'';
					const spellings = (param.spelling||[]).map(s=>s.toLowerCase());

					if(text.includes(term) || id.includes(term) || spellings.some(s=>s.includes(term))){
						return param;
					}

					return null;
				}
			});
			// Country
			$modal.find('#tenant select.select2#country').select2({
				language: _l,
				theme: 'bootstrap-5',
				dropdownParent: $modal,
				data: $.map(d,i=>({
					id: i.alpha3Code,
					text: i.nativeName,
					flag: i.flag,
					spelling: i.altSpellings,
					selected: data.country == i.alpha3Code
				})),
				sorter: param => param.sort((a,b)=>a.text.localeCompare(b.text)),
				templateResult: param => {
					if(!param.id){return param.text??false;}
					return $(`
						<div class="d-flex justify-content-start align-items-center">
							<div class="col-2 text-center"><img class="img-fluid" style="height:40px;width:auto;" alt="${param.text}" src="${param.flag}" /></div>
							<div class="col-10 ps-1">${param.text}</div>
						</div>
					`);
				},
				templateSelection: param => {
					if(!param.id){return param.text??false;}
					return $(`
						<div class="d-flex justify-content-start align-items-center">
							<div class="col-2 text-center"><img class="img-fluid" style="height:40px;width:auto;" alt="${param.text}" src="${param.flag}" /></div>
							<div class="col-10 ps-1">${param.text}</div>
						</div>
					`);
				},
				matcher: (search,param) => {
					if(!param.id){return false;}
					if(!search.term){return param;}

					const term = search.term.toLowerCase();
					const text = param.text?.toLowerCase()??'';
					const id = param.id?.toLowerCase()??'';
					const spellings = (param.spelling||[]).map(s=>s.toLowerCase());

					if(text.includes(term) || id.includes(term) || spellings.some(s=>s.includes(term))){
						return param;
					}

					return null;
				}
			});
		});
		// Cities
		$.getJSON(`${_u}lib/municipios.json`, d => {
			const entriesSorted = Object.entries(d).sort((a,b)=>a[1].localeCompare(b[1]));
			entriesSorted.unshift(["0",_lang.TENANT.NOCITY]);
			$modal.find('#tenant select.select2#city').select2({
				language: _l,
				theme: 'bootstrap-5',
				dropdownParent: $modal,
				data: entriesSorted.map(([k,v])=>({
					id: k,
					text: v,
					selected: k == data.city
				})),
				templateSelection: param => {
					if(!param.id){return param.text??false;}
					return $(`
						<div class="mt-2">${param.text}</div>
					`);
				}
			});
		});
	});

	$modal.find('.submitTenant').on('click', e => {

		const formEl = $modal.find('form#tenant')[0];

		if(!formEl.reportValidity()){
			return;
		}

		const form = new FormData(formEl);
		const json = {};

		for(const[key,value] of form.entries()){
			const arrayMatch = key.match(/^([^\[]+)\[(\d+)\]$/);
			if(arrayMatch){
				const baseKey = arrayMatch[1];
				const index = parseInt(arrayMatch[2]);

				if(!json[baseKey]) json[baseKey]=[];
				json[baseKey][index]=value;
			}else{
				json[key]=value;
			}
		}

		if((json.docType==='DNI'||json.docType==='NIE'||json.docType==='NIF') && json.docNumber===""){
			$(document).find('input#docNumber').focus();
			return;
		}

		if ( $ ( document ).find ( '#wrongDNISupport' ).is ( ':visible' ) || $ ( document ).find ( '#wrongNIESupport' ).is ( ':visible' ) ) {
			$ ( document ).find ( 'input#docNumber' ).focus ();
		}

		if(json.country==='ESP' && (json.city===''||json.city==="0")){
			$(document).find('select#city').focus();
			return;
		}

		if(json.country!=='ESP' && json.locality===''){
			$(document).find('input#locality').focus();
			return;
		}

		if(json.phone[0]===''&&json.email===''){
			$(document).find('input#phone[0]').focus();
			return;
		}

		json.birth = new Date(`${json.birth.substr(6,4)}-${json.birth.substr(3,2)}-${json.birth.substr(0,2)}`).getTime()/1000;

		if ( !data.edit ) {

			$(document).find('.addTenant').after(tenantBlock(data.id,`${json.name} ${json.surname}`,json.relation,JSON.stringify(json)));

		} else {

			$(document).find(`.tenantBlock[data-id="${data.id}"] div:nth-child(1)`).text(`${json.name} ${json.surname}`);
			$(document).find(`.tenantBlock[data-id="${data.id}"] div:nth-child(2)`).text(_lang.TENANT.RELATIONTYPES[json.relation]);
			$(document).find(`input[name="tenant[${data.id}]"]`).val(JSON.stringify(json));

		}

		document.activeElement.blur();
		$bsModal.toggle();
	});

	$modal.on('hidden.bs.modal', () => {
		$modal.find('.submitTenant').off('click');
		$modal.find('#tenant #birth').datepicker('destroy');
		$modal.find('#tenant select.select2#nationality').select2('destroy');
		$modal.find('#tenant select.select2#country').select2('destroy');
		$modal.find('#tenant select.select2#city').select2('destroy');
		$modal.off('shown.bs.modal');
		$modal.off('hidden.bs.modal');
		$bsModal.dispose();
		$modal.remove();
	});

	$modal.on('click', '.btn-close', () => {
		document.activeElement.blur();
		$bsModal.toggle();
	});

}

function tenantBlock(id,name,relation,value) {

	return $(`
		<div class="d-flex justify-content-between align-items-center tenantBlock p-2 mt-3 rounded" style="background-color:var(--bs-gray-500);" data-id="${id}">
			<div class="col-5 text-center">${name}</div>
			<div class="col-4 text-center">${_lang.TENANT.RELATIONTYPES[relation]}</div>
			<div class="col text-center">
				<button type="button" class="btn btn-dark me-1 me-md-5 editTenant" data-id="${id}"><i class="fas fa-pen-to-square pe-none"></i></button>
				<button type="button" class="btn btn-dark removeTenant" data-id="${id}"><i class="fas fa-trash-can pe-none"></i></button>
			</div>
		</div>
		<input type="hidden" name="tenant[${id}]" value='${value}' />
	`);

}

$(document).ready(()=>{

	for(let [k,i] of Object.entries(_tenants)) {
		$(document).find('.addTenant').after(tenantBlock(k,`${i.name} ${i.surname}`,i.relation,JSON.stringify(i)));
	}

	$('#tenants').submit(e=>{
		e.preventDefault();
		e.stopPropagation();

		const tenants = $(document).find('.tenantBlock');

		if(tenants.length == 0){
			$('.alert').modal('show');
			return;
		}

		$.post(`${_u}lib/_aj.php`, $(e.target).serialize(), d => {
			if (d.done) {
				$('.success').modal('show');
				setTimeout(() => {
					location.href = _redirect;
				}, 5000);
			}
		}, 'json');
	});

	if (!$(document).find('.isNew').hasClass('d-none')) {
		$('input[name="date[entry]"]').datepicker({
			todayHighlight: true,
			autoclose: true,
			format: {
				toDisplay: d => {
					var fd = new Date(d);
					return `${fd.getDate().toString().padStart(2,'0')}/${(fd.getMonth()+1).toString().padStart(2,'0')}/${fd.getFullYear()}`;
				},
				toValue: d => d
			},
			language: _l
		});
		$('input[name="date[exit]"]').datepicker({
			todayHighlight: true,
			autoclose: true,
			format: {
				toDisplay: d => {
					var fd = new Date(d);
					return `${fd.getDate().toString().padStart(2,'0')}/${(fd.getMonth()+1).toString().padStart(2,'0')}/${fd.getFullYear()}`;
				},
				toValue: d => d
			},
			language: _l
		});

		$('input[name="date[entry]"]').datepicker().on('changeDate', e => {
			$('input[name="date[exit]"]').datepicker('setStartDate', e.date);
		});
		$('input[name="date[exit]"]').datepicker().on('changeDate', e => {
			$('input[name="date[entry]"]').datepicker('setEndDate', e.date);
		});
	} else {
		$('input[name="date[entry]"]').prop('required',false);
		$('input[name="date[exit]"]').prop('required',false);
	}

	$(document).on('click', '.addTenant', () => addTenant () );

	$(document).on('click','.editTenant', e => {
		const uid = $(e.target).data('id');
		let values = $(document).find(`input[name="tenant[${uid}]"]`).val();
		values = JSON.parse(values);
		addTenant($.extend({id:uid,edit:true,title:_lang.BTNS.EDIT + ` (${values.name} ${values.surname})`},values));
	});

	$(document).on('click','.removeTenant', e => {
		const uid = $(e.target).data('id');
		$(document).find(`.tenantBlock[data-id="${uid}"],input[name="tenant[${uid}]"]`).remove();

		$(document).find('.tenantBlock').each((k,i)=>{
			const actualUid = $(i).data('id');
			$(i).attr('data-id',k);
			$(i).find('.editTenant').attr('data-id',k);
			$(i).find('.removeTenant').attr('data-id',k);
			$(document).find(`input[name="tenant[${actualUid}]"]`).attr('name', `tenant[${k}]`);
		});
	});

});

function onChangeDocType () {

	const value = {
		target: {
			value: $ ( document ).find ( '#docNumber' ).val ()
		}
	};

	if ( value.target.value === '' ) return;

	validateDocSupport ( value );

}

function validateDocSupport ( value ) {

	if ( value.target.value === '' ) return;

	$ ( document ).find ( '#wrongDNISupport, #wrongNIESupport' ).addClass ( 'd-none' );

	const DNI = /^[A-Z]{3}\d{6}$/;
	const NIE = /^[EC]\d{8}$/;

	var alpha = value.target.value.split ( /[\W\d]+/ ).join ( '' ).toUpperCase ();
	var digit = value.target.value.split ( /[^\d]+/ ).join ( '' );
	var parse = '';

	const docType = $ ( '#docType' ).val ();

	switch ( docType ) {
		case 'NIF':
			parse = alpha + digit.padStart ( 6, '0' );
			if ( !DNI.test ( parse ) ) {
				$ ( document ).find ( '#wrongDNISupport' ).removeClass ( 'd-none' );
			} else {
				$ ( document ).find ( '#docNumber' ).val ( parse );
			}
			break;
		case 'NIE':
			parse = alpha + digit.padStart ( 8, '0' );
			if ( !NIE.test ( parse ) ) {
				$ ( document ).find ( '#wrongNIESupport' ).removeClass ( 'd-none' );
			} else {
				$ ( document ).find ( '#docNumber' ).val ( parse );
			}
			break;
	}

}